/* libiso8601/src/setisodate/000_TopSource.c
 *
 *  (c)2007, Laurence Withers, <l@lwithers.me.uk>.
 *  Released under the GNU GPLv2. See file COPYING or
 *  http://www.gnu.org/copyleft/gpl.html for details.
*/

/* Below are all the includes used throughout the application. */
#include <stdio.h>
#include "iso8601.h"



int main(int argc, char* argv[])
{
    struct iso8601_date d;
    char str[100];

    if(argc != 2) {
        fputs("Expecting one argument: date/time (in ISO8601 format) to set.\n", stderr);
        return 1;
    }

    if(iso8601_parse(argv[1], &d, 0, 0)) {
        fputs("Cannot parse date.\n", stderr);
        return 1;
    }

    printf("Setting date to %s.\n",
        iso8601_print(str, sizeof(str), &d, 0));

    if(iso8601_set_sysclock(&d)) {
        perror("iso8601_set_sysclock");
        return 1;
    }

    return 0;
}



/* options for text editors
kate: replace-trailing-space-save true; space-indent true; tab-width 4;
vim: expandtab:ts=4:sw=4
*/
