#!/bin/bash
# release.sh
#
#  Performs a release. This involves uploading the filesystems by rsync to a destination, and
#  tagging the git repository with the build name/number.
#

set -e



#
# Check that there are no outstanding commits
#
X="$(mktemp)"
git ls-files --exclude-standard --modified --others --deleted > "${X}"
[ -s "${X}" ] && COMMITS="1"
rm "${X}"

if [ -n "${COMMITS}" ]
then
    echo "Outstanding commits. Use git-status to view them. Commit before releasing."
    exit 1
fi



#
# Tag release
#
source "./build.version"
git tag "${BUILD_LABEL}-${BUILD_VERSION}"



#
# Upload filesystems via rsync
#
(
    cd "filesystems"
    ./rsync-push.sh "default"
)



#
# Upload crosslib via rsync
#
(
    cd "crosslib"
    ./rsync-push.sh
)



#
# Perform open source license compliance
#
(
    ./opensource.sh
)



# vim: ts=4:sw=4:expandtab
