/* libiso8601/src/libiso8601/400_c_library.h
 *
 *  (c)2006-2010, Laurence Withers, <l@lwithers.me.uk>.
 *  Released under the GNU GPLv3. See file COPYING or
 *  http://www.gnu.org/copyleft/gpl.html for details.
*/



/*! \defgroup c_library C library integration.

These functions enable integration with the C library (system call wrappers and
conversion).

*/
/*!@{*/



/*! \brief Retrieve the current time.

\param[out] date Current date/time (may be 0), in UTC. May be 0.
\param[out] details Details (may be 0), including timezone. May be 0.

Retrieves the current time from the system clock, storing it into \a date and
\a details (both parameters optional).

*/
void iso8601_now(struct iso8601_date* date, struct iso8601_details* details);



/*! \brief Set the system clock.

\param date Date to set.
\retval 0 on success.
\retval -1 on error (and see \a errno).

Attempts to set the system clock using \c clock_settime(), falling back to \c
settimeofday(). The user will need the \c CAP_SYS_TIME capability to set the
clock, otherwise \a errno will be set to \c EPERM.

*/
int iso8601_set_sysclock(const struct iso8601_date* date)
#ifndef DOXYGEN
    __attribute__((nonnull))
#endif
;



/*! \brief Convert from a struct timespec. */
void iso8601_from_ts(struct iso8601_date* date, const struct timespec* ts)
#ifndef DOXYGEN
    __attribute__((nonnull))
#endif
;

/*! \brief Convert to a struct timespec. */
void iso8601_to_ts(struct timespec* ts, const struct iso8601_date* date)
#ifndef DOXYGEN
    __attribute__((nonnull))
#endif
;

/*! \brief Convert from a struct timeval. */
void iso8601_from_tv(struct iso8601_date* date, const struct timeval* tv)
#ifndef DOXYGEN
    __attribute__((nonnull))
#endif
;

/*! \brief Convert to a struct timeval. */
void iso8601_to_tv(struct timeval* tv, const struct iso8601_date* date)
#ifndef DOXYGEN
    __attribute__((nonnull))
#endif
;

/*! \brief Convert from a time_t. */
void iso8601_from_time_t(struct iso8601_date* date, const time_t* t)
#ifndef DOXYGEN
    __attribute__((nonnull))
#endif
;

/*! \brief Convert to a time_t. */
void iso8601_to_time_t(time_t* t, const struct iso8601_date* date)
#ifndef DOXYGEN
    __attribute__((nonnull))
#endif
;



/*!@}*/
/* options for text editors
kate: replace-trailing-space-save true; space-indent true; tab-width 4;
vim: expandtab:ts=4:sw=4:syntax=ch.doxygen
*/
