#!/bin/bash
# libiso8601/test.sh
# 
#  Copyright: ©2009–2011, Güralp Systems Ltd.
#  Author: Laurence Withers <lwithers@guralp.com>
#  License: GPLv3
#

# Running this script on its own will display a summary of all the
# available tests; running it with arguments runs the relevant test.



# This runs a test, setting the correct library path.
run_test() {
    EXE=obj/tests/$1
    shift
    if [ ! -x ${EXE} ]
    then
        echo "No such test '${EXE}'"
        return 1
    fi

    LD_LIBRARY_PATH="obj:${LD_LIBRARY_PATH}" "${EXE}" "$@" || return 1
    return 0
}



# This prints summary output from each test app.
print_tests() {
    echo "Available tests"
    echo "---------------------------------------------------------------------"
    for EXE in obj/tests/*
    do
        [ -x "${EXE}" ] || continue
        NAME="$(echo "${EXE}" | sed 's,obj/tests/,,')"
        echo -ne "${NAME}\t"
        LD_LIBRARY_PATH="obj:${LD_LIBRARY_PATH}" "${EXE}" --print-summary
    done
}



# Main script
if [ $# -eq 0 ]
then
    print_tests
    exit 0
fi

run_test "$@"

# vim: expandtab:ts=4:sw=4
