# libiso8601/scripts/functions.sh
#
#  Copyright: ©2007–2011, Güralp Systems Ltd.
#  Author: Laurence Withers, <lwithers@guralp.com>
#  License: GPLv3
#

# Common functions



# Print a success message
print_success() {
    if [ -z "${TERM}" -o "${TERM}" == "dumb" ]
    then
        echo -n " - "
    else
        (echo -n -e " \E[32m* "; tput sgr0)
    fi
    echo $*
}



# Print a failure message
print_failure() {
    if [ -z "${TERM}" -o "${TERM}" == "dumb" ]
    then
        echo -n " *** "
    else
        (echo -n -e " \E[31m*** "; tput sgr0)
    fi
    echo $*
}



# This function carries out a command, but reports its failure if
# necessary.
do_cmd() {
    [ "${VERBOSE}" != "0" ] && echo "$@"
    "$@"
    if [ $? -ne 0 ]
    then
        print_failure "'$@' failed."
        return 1
    fi
}



# This function carries out a command, but reports its failure if
# necessary.
do_cmd_redir() {
    DEST=$1
    shift
    [ "${VERBOSE}" != "0" ] && echo "$@ >> ${DEST}"
    "$@" >> ${DEST}
    if [ $? -ne 0 ]
    then
        print_failure "'$@' failed."
        return 1
    fi
}

# vim: expandtab:ts=4:sw=4
