/* libCStreamedXML/src/tests/callback.c
 *
 *  (c)2006, Laurence Withers, <l@lwithers.me.uk>.
 *  Released under the GNU GPLv2. See file COPYING or
 *  http://www.gnu.org/copyleft/gpl.html for details.
*/

#include "StreamedXML.h"

#include <stdio.h>
#include <string.h>



int echo_whiteSpace(const struct csxml* ctx, const char* ws)
{
    (void)ctx;
    printf("Whitespace: ``%s''\n", ws);
    return 0;
}

int echo_content(const struct csxml* ctx, const char* data)
{
    (void)ctx;
    printf("Content: ``%s''\n", data);
    return 0;
}

int echo_cdata(const struct csxml* ctx, const char* data)
{
    (void)ctx;
    printf("CDATA: ``%s''\n", data);
    return 0;
}

int echo_streamRestart(const struct csxml* ctx, const char* data)
{
    (void)ctx;
    printf("Stream restart marker: ``%s''\n", data);
    return 0;
}

int echo_PI(const struct csxml* ctx, const char* target, const char* data)
{
    (void)ctx;
    printf("PI: target ``%s'', data ", target);
    if(data) printf("``%s''\n", data);
    else printf("not specified\n");
    return 0;
}

int echo_comment(const struct csxml* ctx, const char* data)
{
    (void)ctx;
    printf("Comment: ``%s''\n", data);
    return 0;
}

int echo_element(const struct csxml* ctx, const char* elemName, int numAttrs)
{
    int i;

    printf("Open tag: <%s> (%d attributes)\n", elemName, numAttrs);
    for(i = 0; i < numAttrs; ++i) printf("  %s='%s'\n", ctx->elemAttrNames.data[i].data, ctx->elemAttrVals.data[i].data);
    return 0;
}

int echo_closeTag(const struct csxml* ctx, const char* elemName)
{
    (void)ctx;
    printf("Close tag: </%s>\n", elemName);
    return 0;
}

const char* echo_entityRef(const struct csxml* ctx, const char* ent)
{
    (void)ctx;
    printf("Entity reference: ``%s''\n", ent);
    return 0;
}



int main(int argc, char* argv[])
{
    FILE* fp = 0;
    char buf[1024];
    size_t amt;
    struct csxml* ctx = 0;

    if(argc == 2 && !strcmp(argv[1], "--print-summary")) {
        printf("Tests the callback functions.\n");
        return 0;
    }

    if(argc != 2) {
        fprintf(stderr, "Expecting filename.\n");
        return 1;
    }

    fp = fopen(argv[1], "r");
    if(!fp) {
        fprintf(stderr, "Error opening '%s' for input.\n", argv[1]);
        return 1;
    }

    ctx = csxml_newParser();
    if(!ctx) {
        fprintf(stderr, "Couldn't allocate a new parser.\n");
        return 1;
    }

    ctx->whiteSpace = echo_whiteSpace;
    ctx->content = echo_content;
    ctx->cdata = echo_cdata;
    ctx->streamRestart = echo_streamRestart;
    ctx->PI = echo_PI;
    ctx->comment = echo_comment;
    ctx->element = echo_element;
    ctx->closeTag = echo_closeTag;
    ctx->entityRef = echo_entityRef;

    while(!feof(fp)) {
        amt = fread(buf, 1, sizeof(buf), fp);
        csxml_feedData(ctx, buf, amt);
    }

    csxml_freeParser(ctx);
    fclose(fp);

    return 0;
}

/* options for text editors
kate: replace-trailing-space-save true; space-indent true; tab-width 4;
vim: expandtab:ts=4:sw=4
*/
