/* libiso8601/src/tests/parser.c
 *
 *  (c)2006, Laurence Withers, <l@lwithers.me.uk>.
 *  Released under the GNU GPLv2. See file COPYING or
 *  http://www.gnu.org/copyleft/gpl.html for details.
*/

#include "iso8601.h"

#include <stdio.h>
#include <string.h>



int do_date(const char* str)
{
    struct iso8601_date earliest, latest;
    struct iso8601_details details, fulldetails;
    char buf[100], buf2[100], buf3[100], buf4[100];

    if(iso8601_parse(str, &earliest, &latest, &details)) {
        fputs("Failed to parse date.\n", stderr);
        return 1;
    }

    memset(&fulldetails, 0, sizeof(fulldetails));
    switch((fulldetails.date_prec = details.date_prec)) {
    case iso8601_prec_month:
    case iso8601_prec_year: 
        fulldetails.date_prec = iso8601_prec_day; 
        break;
    case iso8601_prec_week:
        fulldetails.date_prec = iso8601_prec_wday;
        break;
    }
    fulldetails.time_prec = iso8601_prec_secfrac;

    iso8601_print(buf, sizeof(buf), &earliest, &details);
    iso8601_print(buf2, sizeof(buf2), &earliest, &fulldetails);
    iso8601_print(buf3, sizeof(buf3), &latest, &details);
    iso8601_print(buf4, sizeof(buf4), &latest, &fulldetails);

    printf("Results for ``%s'':\n"
        "  Earliest: day=%d, sec=%05d, nsec=%09d; %-20s  %s\n"
        "  Latest  : day=%d, sec=%05d, nsec=%09d; %-20s  %s\n"
        "  Details : date_prec=%d, time_prec=%d, extended=%d, tz_sec=%d\n"
        "\n",
        str,
        earliest.day, earliest.sec, earliest.nsec, buf, buf2,
        latest.day, latest.sec, latest.nsec, buf3, buf4,
        details.date_prec, details.time_prec, details.extended, details.tz_sec);

    return 0;
}



int main(int argc, char* argv[])
{
    int ret = 0, i;
    char* buf = 0;
    size_t buf_size;

    if(argc == 2 && !strcmp(argv[1], "--print-summary")) {
        printf("One line summary.\n");
        return 0;
    }

    if(argc == 1) {
        while(!feof(stdin)) {
            printf("date >> ");
            if(getline(&buf, &buf_size, stdin) < 1) continue;
            do_date(buf);
        }

        return 0;
    }

    for(i = 1; i < argc; ++i) {
        ret |= do_date(argv[i]);
    }

    return ret;
}

/* options for text editors
kate: replace-trailing-space-save true; space-indent true; tab-width 4;
vim: expandtab:ts=4:sw=4
*/
