/* libCStreamedXML/src/libCStreamedXML/000_TopHeader.h
 *
 *  (c)2006, Laurence Withers, <l@lwithers.me.uk>.
 *  Released under the GNU GPLv2. See file COPYING or
 *  http://www.gnu.org/copyleft/gpl.html for details.
*/

#ifndef HEADER_libCStreamedXML
#define HEADER_libCStreamedXML

// standard includes, or includes needed for type declarations
#include <sys/types.h>

/*! \defgroup libCStreamedXML libCStreamedXML interface.

libCStreamedXML is a C library for parsing Streamed XML data. It is somewhat simpler than the C++
library (it only parses ASCII data, not Unicode data). In future, the API could be extended to
use only fixed-size buffers, and not to call malloc() at all. This would be advantageous for small
embedded systems (e.g. PICs).

To parse Streamed XML, you must first create a parser context object with csxml_newParser(). Then
you set up the returned object by changing options and callback functions. Once set up correctly,
pass in data using the csxml_feedChar() and csxml_feedData() functions. Finally, free the parser
object with csxml_freeParser().

*/
/*!@{*/

/* options for text editors
kate: replace-trailing-space-save true; space-indent true; tab-width 4;
vim: expandtab:ts=4:sw=4
*/
