# These are external variables, and shouldn't clash with anything else
#  isodate
#  isodate_BUILT
#

if [ -z ${isodate_BUILT} ]
then
    isodate="obj/isodate"
    EXTRAS="-std=gnu99 -D_GNU_SOURCE -DAPP_NAME=\"isodate\" \
        ${libiso8601} ${libiso8601_DEP_CFLAGS} ${libiso8601_DEP_LIBS}"

    echo "Building application ${isodate}..."

    do_cmd source src/isodate/build.monolithic || return 1

    MODIFIED=0
    for test in ${MONOLITHIC_TESTS} ${SRC}
    do
        if [ ${test} -nt ${isodate} ]
        then
            MODIFIED=1
            break
        fi
    done

    if [ ${MODIFIED} -ne 0 ]
    then
        echo " Compiling..."

        do_cmd ${CC} ${CFLAGS} -I obj -o "${isodate}" ${SRC} ${EXTRAS} || return 1

        print_success "Application built"
    else
        print_success "Application up to date"
    fi

    isodate_BUILT=1

fi

# vim: syntax=sh:expandtab:ts=4:sw=4
