# libutf8/scripts/functions.sh
#
#  (c)2006-2009, Laurence Withers, <l@lwithers.me.uk>.
#  Released under the GNU GPLv3. See file COPYING or
#  http://www.gnu.org/copyleft/gpl.html for details.
#

# Common functions



# Print a success message
print_success() {
    if [ -z "${TERM}" -o "${TERM}" == "dumb" ]
    then
        echo -n " - "
    else
        (echo -n -e " \E[32m* "; tput sgr0)
    fi
    echo $*
}



# Print a failure message
print_failure() {
    if [ -z "${TERM}" -o "${TERM}" == "dumb" ]
    then
        echo -n " *** "
    else
        (echo -n -e " \E[31m*** "; tput sgr0)
    fi
    echo $*
}



# This function carries out a command, but reports its failure if
# necessary.
do_cmd() {
    [ "${VERBOSE}" != "0" ] && echo "$@"
    "$@"
    if [ $? -ne 0 ]
    then
        print_failure "'$@' failed."
        return 1
    fi
}



# This function carries out a command, but reports its failure if
# necessary.
do_cmd_redir() {
    DEST=$1
    shift
    [ "${VERBOSE}" != "0" ] && echo "$@ >> ${DEST}"
    "$@" >> ${DEST}
    if [ $? -ne 0 ]
    then
        print_failure "'$@' failed."
        return 1
    fi
}

# kate: replace-trailing-space-save true; space-indent true; tab-width 4;
# vim: expandtab:ts=4:sw=4
