/* libutf8/src/libutf8/100_ctype.c
 *
 *  (c)2006-2009, Laurence Withers, <l@lwithers.me.uk>.
 *  Released under the GNU GPLv3. See file COPYING or
 *  http://www.gnu.org/copyleft/gpl.html for details.
*/



int
utf8_isascii(wchar_t ch)
{
    return !(ch & ~0x7F);
}



int
utf8_isspace(wchar_t ch)
{
    return((ch >= 0x0009 && ch <= 0x000D)
            || ch == 0x0020
            || ch == 0x0085
            || ch == 0x00A0
            || ch == 0x1680
            || ch == 0x180E
            || (ch >= 0x2000 && ch <= 0x200A)
            || ch == 0x2028
            || ch == 0x2029
            || ch == 0x202F
            || ch == 0x205F
            || ch == 0x3000);
}



int
utf8_iseol(wchar_t ch)
{
    return (ch >= 0x000A && ch <= 0x000D)
        || ch == 0x0085
        || ch == 0x2028
        || ch == 0x2029;
}



int
utf8_isucs4(wchar_t ch)
{
    return !(ch & (~((wchar_t)0x7FFFFFFF)))
        && (ch < 0xD800 || ch > 0xDFFF)
        && (ch != 0xFFFE) && (ch != 0xFFFF);
}



int
utf8_isutf32(wchar_t ch)
{
    return ch >= 0 && ch <= 0x10FFFF
        && (ch < 0xD800 || ch > 0xDFFF)
        && (ch != 0xFFFE) && (ch != 0xFFFF);
}



int
utf8_isutf16(wchar_t ch)
{
    return ch >= 0 && ch <= 0xFFFD
        && (ch < 0xD800 || ch > 0xDFFF);
}



/* options for text editors
kate: replace-trailing-space-save true; space-indent true; tab-width 4;
vim: expandtab:ts=4:sw=4:syntax=c.doxygen
*/
