# These are external variables, and shouldn't clash with anything else
#  setisodate
#  setisodate_BUILT
#

build_target libiso8601

if [ -z ${setisodate_BUILT} ]
then
    setisodate="obj/setisodate"
    EXTRAS="-std=gnu99 -D_GNU_SOURCE -DAPP_NAME=\"setisodate\" \
        ${libiso8601} ${libiso8601_DEP_CFLAGS} ${libiso8601_DEP_LIBS}"

    echo "Building application ${setisodate}..."

    do_cmd source src/setisodate/build.monolithic || return 1

    MODIFIED=0
    for test in ${MONOLITHIC_TESTS} ${SRC}
    do
        if [ ${test} -nt ${setisodate} ]
        then
            MODIFIED=1
            break
        fi
    done

    if [ ${MODIFIED} -ne 0 ]
    then
        echo " Compiling..."

        do_cmd ${CC} ${CFLAGS} -I obj -o "${setisodate}" ${SRC} ${EXTRAS} || return 1

        print_success "Application built"
    else
        print_success "Application up to date"
    fi

    setisodate_BUILT=1

fi

# vim: syntax=sh:expandtab:ts=4:sw=4
