/* libiso8601/src/tests/printer.c
 *
 *  (c)2006, Laurence Withers, <l@lwithers.me.uk>.
 *  Released under the GNU GPLv2. See file COPYING or
 *  http://www.gnu.org/copyleft/gpl.html for details.
*/

#include "iso8601.h"

#include <stdio.h>
#include <string.h>



void do_details_local(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
}

void do_details_local_nofrac(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->time_prec = iso8601_prec_sec;
}

void do_details_local_min(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->time_prec = iso8601_prec_min;
}

void do_details_local_minfrac(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->time_prec = iso8601_prec_minfrac;
}

void do_details_local_hour(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->time_prec = iso8601_prec_hour;
}

void do_details_local_hourfrac(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->time_prec = iso8601_prec_hourfrac;
}

void do_details_local_day(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->time_prec = iso8601_prec_none;
}

void do_details_local_month(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->date_prec = iso8601_prec_month;
}

void do_details_local_year(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->date_prec = iso8601_prec_year;
}

void do_details_utc(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->tz_sec = 0;
}

void do_details_utc_nofrac(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->tz_sec = 0;
    dt_out->time_prec = iso8601_prec_sec;
}

void do_details_utc_min(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->tz_sec = 0;
    dt_out->time_prec = iso8601_prec_min;
}

void do_details_utc_minfrac(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->tz_sec = 0;
    dt_out->time_prec = iso8601_prec_minfrac;
}

void do_details_utc_hour(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->tz_sec = 0;
    dt_out->time_prec = iso8601_prec_hour;
}

void do_details_utc_hourfrac(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->tz_sec = 0;
    dt_out->time_prec = iso8601_prec_hourfrac;
}

void do_details_utc_day(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->tz_sec = 0;
    dt_out->time_prec = iso8601_prec_none;
}

void do_details_utc_month(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->tz_sec = 0;
    dt_out->date_prec = iso8601_prec_month;
}

void do_details_utc_year(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->tz_sec = 0;
    dt_out->date_prec = iso8601_prec_year;
}

void do_details_ordinal_date(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->tz_sec = 0;
    dt_out->date_prec = iso8601_prec_ord;
    dt_out->time_prec = iso8601_prec_none;
}

void do_details_ordinal(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->tz_sec = 0;
    dt_out->date_prec = iso8601_prec_ord;
}

void do_details_week(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->tz_sec = 0;
    dt_out->date_prec = iso8601_prec_week;
}

void do_details_week_day(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->tz_sec = 0;
    dt_out->date_prec = iso8601_prec_wday;
    dt_out->time_prec = iso8601_prec_none;
}

void do_details_week_full(struct iso8601_details* dt_out, const struct iso8601_details* dt_in)
{
    memcpy(dt_out, dt_in, sizeof(struct iso8601_details));
    dt_out->tz_sec = 0;
    dt_out->date_prec = iso8601_prec_wday;
}



struct test {
    const char* desc;
    void (*do_details)(struct iso8601_details* dt_out, const struct iso8601_details* dt_in);
};
const struct test tests[] = {
    { "UTC with fraction", do_details_utc },
    { "UTC without fraction", do_details_utc_nofrac },
    { "UTC minute", do_details_utc_min },
    { "UTC minute with fraction", do_details_utc_minfrac },
    { "UTC hour", do_details_utc_hour },
    { "UTC hour with fraction", do_details_utc_hourfrac },
    { "UTC day", do_details_utc_day },
    { "UTC month", do_details_utc_month },
    { "UTC year", do_details_utc_year },
    { "Local with fraction", do_details_local },
    { "Local without fraction", do_details_local_nofrac },
    { "Local minute", do_details_local_min },
    { "Local minute with fraction", do_details_local_minfrac },
    { "Local hour", do_details_local_hour },
    { "Local hour with fraction", do_details_local_hourfrac },
    { "Local day", do_details_local_day },
    { "Local month", do_details_local_month },
    { "Local year", do_details_local_year },
    { "Ordinal date", do_details_ordinal_date },
    { "Ordinal full", do_details_ordinal },
    { "Week number", do_details_week },
    { "Week date", do_details_week_day },
    { "Week full", do_details_week_full },
    { 0, 0 }
};



int main(int argc, char* argv[])
{
    int ret = 0;
    struct iso8601_date dt;
    struct iso8601_details details, details2;
    char buf[40], buf2[40];
    const struct test* test;

    if(argc == 2 && !strcmp(argv[1], "--print-summary")) {
        printf("Prints the current time in various formats.\n");
        return 0;
    }

    iso8601_now(&dt, &details);
    printf("%-30s  %-30s  %s\n", "Name", "Basic format", "Extended format");
    for(test = tests; test->desc; ++test) {
        memset(buf, 'X', sizeof(buf));
        memset(buf2, 'X', sizeof(buf2)); /* test null-termination */

        test->do_details(&details2, &details);

        iso8601_print(buf, sizeof(buf), &dt, &details2);
        ++details2.extended;
        iso8601_print(buf2, sizeof(buf2), &dt, &details2);
        printf("%-30s  %-30s  %s\n", test->desc, buf, buf2);
    }

    return ret;
}

/* options for text editors
kate: replace-trailing-space-save true; space-indent true; tab-width 4;
vim: expandtab:ts=4:sw=4
*/
