# LCDd.conf -- configuration file for the LCDproc server daemon LCDd

# This file is cut down from the distributed file as we only need
# support for the Crystalfonz and hd44780 devices at present.
# See the distributed file for additional documentation.


## Server section with all kinds of settings for the LCDd server ##
[server]

# The following drivers are supported:
#   CFontz, CFontz633, CFontzPacket, hd44780
# We ship configured for the hd44780, if a CFontz USB module is plugged in udev
# will detect it and call lcdproc-setup to adjust the configuration.
Driver=hd44780

# Tells the driver to bind to the given interface
Bind=127.0.0.1

# Listen on this specified port; defaults to 13666.
Port=13666

# Sets the reporting level; defaults to 2 (warnings and errors only).
#ReportLevel=3

# Should we report to syslog instead of stderr ? Default: no
#ReportToSyslog=yes

# Sets the default time in seconds to displays a screen.
WaitTime=5

# User to run as.  LCDd will drop its root priviledges,
# if any, and run as this user instead.
User=nobody

# If yes, the the serverscreen will be rotated as a usual info screen. If no,
# it will be a background screen, only visible when no other screens are
# active.
ServerScreen=no

# The server will stay in the foreground if set to true.
#Foreground=no

# Where can we find the driver modules ?
# IMPORTANT: Make sure to change this setting to reflect your
#            specific setup! Otherwise LCDd won't be able to find
#            the driver modules and will thus not be able to
#            function properly.
# NOTE: Always place a slash as last character !
DriverPath=/usr/lib/lcdproc/

# Hello message: each entry represents a display line; default: builtin
#Hello="  Welcome to"
#Hello="   LCDproc!"

# GoodBye message: each entry represents a display line; default: builtin
#GoodBye="Thanks for using"
#GoodBye="   LCDproc!"

# The "...Key=" lines define what the server does with keypresses that
# don't go to any client.
# These are the defaults:
ToggleRotateKey=Enter
PrevScreenKey=Left
NextScreenKey=Right
#ScrollUpKey=Up
#ScrollDownKey=Down



## The menu section. The menu is an internal LCDproc client. ##
[menu]
# You can configure what keys the menu should use. Note that the MenuKey
# will be reserved exclusively, the others work in shared mode.

# The following works excellent with 4 keys or more.
MenuKey=Escape
EnterKey=Enter
UpKey=Up
DownKey=Down



### Driver sections are below this line, in alphabetical order  ###


## CrystalFontz driver (for CF632 & CF634) ##
[CFontz]

# Select the output device to use [default: /dev/lcd]
Device=/dev/ttyS0
# Select the LCD size [default: 20x4]
Size=20x4
# Set the initial contrast [default: 560; legal: 0 - 1000]
Contrast=350
# Set the initial brightness [default: 1000; legal: 0 - 1000]
Brightness=1000
# Set the initial off-brightness [default: 0; legal: 0 - 1000]
# This value is used when the display is normally
# switched off in case LCDd is inactive
OffBrightness=0
# Set the communication speed [default: 9600; legal: 1200, 2400, 9600, 19200 or 115200]
Speed=9600
# Set the firmware version (New means >= 2.0) [default: no; legal: yes, no]
NewFirmware=no
# Reinitialize the LCD's BIOS [default: no; legal: yes, no]
# normally you shouldn't need this
Reboot=no



## CrystalFontz633 driver (for CF633 only) ##
[CFontz633]

# Select the output device to use [default: /dev/lcd]
Device=/dev/ttyS0
# Select the LCD type (size) [default: 16x2]
Size=16x2
# Set the initial contrast [default: 560; legal: 0 - 1000]
Contrast=350
# Set the initial brightness [default: 1000; legal: 0 - 1000]
Brightness=1000
# Set the initial off-brightness [default: 0; legal: 0 - 1000]
# This value is used when the display is normally
# switched off in case LCDd is inactive
OffBrightness=50
# Set the communication speed [default: 9600; legal: 1200, 2400, 9600, 19200, 115200]
Speed=19200
# Set the firmware version (New means >= 2.0) [default: no; legal: yes, no]
# Currently this flag is not in use, there is no such thing as NewFirmware. ;=)
#NewFirmware=no
# Reinitialize the LCD's BIOS [default: no; legal: yes, no]
# I want to reboot the LCD to make sure we start from a known state
Reboot=yes



## CrystalFontz packet driver (for CF631, CF633 & CF635) ##
[CFontzPacket]

# Select the LCD model [default: 633; legal: 631, 633, 635]
Model=NotSet
# Select the output device to use [default: /dev/lcd]
Device=/dev/lcd
# Select the LCD size [default: depending on model: 635: 20x4, 631: 20x2, 633: 16x2]
Size=16x2
# Set the initial contrast [default: 560; legal: 0 - 1000]
Contrast=350
# Set the initial brightness [default: 1000; legal: 0 - 1000]
Brightness=1000
# Set the initial off-brightness [default: 0; legal: 0 - 1000]
# This value is used when the display is normally
# switched off in case LCDd is inactive
OffBrightness=50
# Set the communication speed [default: 9600; legal: 1200, 2400, 9600, 19200, 115200]
Speed=19200
# Set the firmware version (New means >= 2.0) [default: no; legal: yes, no]
# Currently this flag is not in use, there is no such thing as NewFirmware. ;=)
#NewFirmware=no
# Reinitialize the LCD's BIOS [default: no; legal: yes, no]
# I want to reboot the LCD to make sure we start from a known state
Reboot=yes


## GSL I2C HD44780 driver (uses gsli2c lib) ##
[hd44780]

ConnectionType=gsli2c

# gsli2c device names for the port expander and the contrast pot
Device=lcd_port
ContrastPot=lcd_contrast

# The controller is actually an HD66712
ExtendedMode=yes

# Module characteristics
Keypad=no
Backlight=yes
OutputPort=yes
Size=20x4

# Initial contrast setting
Contrast=0
