#!/bin/sh
#  vim: ts=4:sw=4:expandtab
#
#  Generate/regenerate stunnel SSL keys.
#

STUNNEL="/etc/stunnel"

STUNNEL_CERT_DIR="${STUNNEL}/certs.local"
STUNNEL_KEY_FILE="${STUNNEL_CERT_DIR}/stunnel_key.pem"
STUNNEL_CERT_FILE="${STUNNEL_CERT_DIR}/stunnel_cert.pem"

STUNNEL_CNF="${STUNNEL}/stunnel.cnf"
STUNNEL_RSA_BITS="1024"
STUNNEL_CERT_DAYS="3650"

die() {
    echo "*** " "$@"
    exit 1
}

if [ ! -s "${STUNNEL_KEY_FILE}" ]
then
    echo "Generating new RSA key for stunnel"
    mkdir -p "${STUNNEL_CERT_DIR}"
    openssl genrsa "${STUNNEL_RSA_BITS}" > "${STUNNEL_KEY_FILE}" \
        || die "Unable to generate RSA key"
    chmod 0600 "${STUNNEL_KEY_FILE}"
fi

if [ ! -s "${STUNNEL_CERT_FILE}" ]
then
    echo "Generating new RSA certificate for stunnel"
    openssl req -new -x509 -nodes -sha1 -days "${STUNNEL_CERT_DAYS}" \
        -key "${STUNNEL_KEY_FILE}" -config "${STUNNEL_CNF}" -batch \
        > "${STUNNEL_CERT_FILE}" \
        || die "Unable to generate RSA certificate"
fi

true
