#!/bin/sh
# libCStreamedXML/test.sh
#
#  (c)2009, Laurence Withers, <l@lwithers.me.uk>.
#  Released under the GNU GPLv3. See file COPYING or
#  http://www.gnu.org/copyleft/gpl.html for details.
#

# Running this script on its own will display a summary of all the
# available tests; running it with arguments runs the relevant test.



# This runs a test, setting the correct library path.
run_test() {
    EXE=obj/tests/$1
    shift
    if [ ! -x ${EXE} ]
    then
        echo "No such test '${EXE}'"
        return 1
    fi

    LD_LIBRARY_PATH="obj" "${EXE}" "$@" || return 1
    return 0
}



# This prints summary output from each test app.
print_tests() {
    echo "Available tests"
    echo "---------------------------------------------------------------------"
    for EXE in obj/tests/*
    do
        [ -x ${EXE} ] || continue
        NAME=$(echo ${EXE} | sed 's,obj/tests/,,')
        echo -ne "${NAME}\t"
        LD_LIBRARY_PATH="obj" ${EXE} --print-summary
    done
}


# Main script
if [ $# -eq 0 ]
then
    print_tests
    exit 0
fi

run_test $*

# kate: replace-trailing-space-save true; space-indent true; tab-width 4;
# vim: expandtab:ts=4:sw=4
