/* libCStreamedXML/src/libCStreamedXML/200_defaults.c
 *
 *  (c)2006, Laurence Withers. Released under the GNU GPL. See file
 *  COPYING for more information / terms of license.
*/

static void default_notWellFormed(const struct csxml* ctx, const char* reason)
{
    fprintf(stderr, "Streamed XML is not well formed.\n  Line  : %d\n  Col   : %d\n  Reason: %s\n",
        ctx->line + 1, ctx->col + 1, reason);
}



static void default_outOfMemory(const struct csxml* ctx, size_t amount)
{
    (void)ctx;
    fprintf(stderr, "Streamed XML parser: out of memory allocating %lu bytes\n", (unsigned long)amount);
}



static void default_unknownEntity(const struct csxml* ctx, const char* ent)
{
    fprintf(stderr, "Unknown entity referenced in Streamed XML.\n  Line: %d\n  Col : %d\n  Name: %s\n",
        ctx->line + 1, ctx->col + 1, ent);
}



static int default_discard(const struct csxml* ctx, const char* x)
{
    (void)ctx;
    (void)x;
    return 0;
}



static int default_cdata(const struct csxml* ctx, const char* data)
{
    return ctx->content(ctx, data);
}



static int default_discardPI(const struct csxml* ctx, const char* target, const char* data)
{
    (void)ctx;
    (void)target;
    (void)data;
    return 0;
}



static int default_discardElem(const struct csxml* ctx, const char* elemName, int numAttrs)
{
    (void)ctx;
    (void)elemName;
    (void)numAttrs;
    return 0;
}



static const char* default_discardEnt(const struct csxml* ctx, const char* ent)
{
    (void)ctx;
    (void)ent;
    return 0;
}



/* options for text editors
kate: replace-trailing-space-save true; space-indent true; tab-width 4;
vim: expandtab:ts=4:sw=4
*/
