#!/bin/sh
#
#  Guralp Systems Ltd.
#
#  Generate GSL and wpa_supplicant configuration information for new wlan
#  interfaces.
#
#  Copyright (c) 2009 Guralp Systems Ltd.	http://www.guralp.com/
#  Author:  R.J.Dunlop                          <rdunlop@guralp.com>
#  Released under the GNU GPLv3. See file COPYING or
#  http://www.gnu.org/copyleft/gpl.html for details.
#

# Typical parameters we are passed in the environment:
#  UDEV_LOG=3
#  ACTION=add
#  SEQNUM=469
#  IFINDEX=4
#  DEVPATH=/class/net/wlan0
#  SUBSYSTEM=net
#  PHYSDEVPATH=/class/mmc_host/mmc0/mmc0:0001/mmc0:0001:1
#  PHYSDEVDRIVER=libertas_sdio
#  INTERFACE=wlan0
#  UDEVD_EVENT=1
#  PHYSDEVBUS=sdio

# Simple parameter check in case the user trys running it direct
if [ -z "$INTERFACE" -o -z "$ACTION" ]
then
	echo "INTERFACE and ACTION must be specified"
	exit 1
fi


CFGDIR=/etc/conf.local/ifcfg-$INTERFACE

add_interface() {
	
	# Quick exit if we've already created the files
	[ -f $CFGDIR/dev ] && exit 0

	# Create the files, dev last as it's used for the above check
	mkdir -p $CFGDIR

	# wpa_supplicant.conf
	cat > $CFGDIR/wpa_supplicant.conf <<'EOF'
# Enable the control interface
ctrl_interface=DIR=/var/run/wpa_supplicant

# This fallback network connects to any unsecured access point.
network={
	id_str="baseline_fallback"
	key_mgmt=NONE
	priority=-9999999
}
EOF

	# ip.baseline_fallback
	cat > $CFGDIR/ip.baseline_fallback <<'EOF'
# DHCP settings
bootproto="dhcp"
dhcpcd_args=""

# static settings, first address
default_address_ip=""
default_address_broadcast=""
default_address_args=""
default_route_via=""
default_route_args=""
EOF

	# dev
	echo "device=$INTERFACE"                       > $CFGDIR/dev
	echo "desc=\"Wireless interface $INTERFACE\"" >> $CFGDIR/dev
}

del_interface() {
	: NOOP at present
}


case "X$ACTION" in
Xadd)		add_interface	;;
Xremove)	del_interface	;;
esac

exit 0
